package queue

import (
	"fmt"
	"os"
	"os/signal"
	"syscall"

	"github.com/wind-c/comqtt/v2/cluster/log"
)

var MainQueue Queue

func Init() {
	queue, err := NewQueue(os.Getenv("QUEUE_STATE_FOLDER") + "/main.json")
	if err != nil {
		log.Fatal("Error initializing main queue:", err)
	}

	// Set up signal handling for clean exit
	exitChan := make(chan os.Signal, 1)
	signal.Notify(exitChan, os.Interrupt, syscall.SIGTERM)

	MainQueue = *queue
	go func() {
		<-exitChan
		fmt.Println("\nSaving main queue state before exiting...")
		fmt.Println("\nCurrent queue size: ", MainQueue.GetCurrentSize())
		if err := MainQueue.Save(); err != nil {
			fmt.Println("Error saving main queue state:", err)
		} else {
			fmt.Println("Main queue state saved successfully.")
		}
		os.Exit(0)
	}()
}
