package database

import (
	"gorm.io/gorm"
	"jonasled.dev/jonasled/ems-esp-logger/database/tables"
	"jonasled.dev/jonasled/ems-esp-logger/log"
)

var valueTypeCache = make(map[string]tables.ValueType)

func GetOrCreateValueType(name string) tables.ValueType {
	if cachedValueType, found := valueTypeCache[name]; found {
		return cachedValueType
	}

	// If it's not in the cache, query the database
	var valueType tables.ValueType
	err := Db.Where("name = ?", name).First(&valueType).Error

	if err != nil {
		if err == gorm.ErrRecordNotFound {
			valueType = tables.ValueType{
				Name: name,
			}
			if err := Db.Create(&valueType).Error; err != nil {
				log.Log.Fatalf("Failed to create value type: %v", err)
			}
			log.Log.Infof("Created new value type: %+v\n", valueType)
		} else {
			log.Log.Errorf("Failed to query database: %v", err)
		}
	}

	valueTypeCache[name] = valueType

	return valueType
}
